;;########################################################################
;; logliplg.lsp
;; Copyright (c) 2000 by Pedro Valero
;; ViSta Plugin for Regression Analysis with categorical variables
;; Adapted from Young's frequency plugin
;;########################################################################

;(require "vista")

; PLUGIN STEP 1: PLUGIN VARIABLE BINDINGS

(setf *RewCat-plugin-path* (strcat *plugin-path* "Regcat" *separator*))
(let ((menu-item-title "Regression with Categorical variables")
      (tool-name "RegwCat")
      (model-prefix "RwC")
      (ok-data-types '("class" "multivariate" "general"  ));
      (ok-variable-types '(numeric category))
     ; (*RewCat-plugin-path* (strcat *plugin-path* "Regcat" *separator*))
      )

  (send *vista* :install-plugin tool-name menu-item-title ok-data-types)

  ;; PLUGIN STEP 2: PLUGIN CONSTRUCTOR FUNCTION
  
  (defun Regression-with-Categorical-variables 
    (&key
     (data   *current-data*)
     (title menu-item-title) ; menu-item-title
     (name   tool-name)
     (dialog t))
    "Args: &key Function for Regression analysis with categorical variables."
    (let* (
           (data data)
           (title title)
           (name name)
           (num-vars (length (send data :active-variables '(numeric category))))
           ;follows dialog
           (list-variables (send list-item-proto :new (send data :active-variables '(numeric)) :columns 2))
           (res)
           (OK (send button-item-proto :new "OK" 
                   :action #'(lambda () 
                              (let* 
                                ((res (send list-variables :selection))
                                 
                                 (y-vector (select (column-list (send data :active-data-matrix '(numeric))) res))
                                 (y-name (select (send data :active-variables '(numeric)) res))
                                 (excluded-categories (mapcar #'(lambda (var) 
                                                                  (first (sort-data (remove-duplicates var :test 'equalp))))
                                                              (send data :active-data-lists '(category))))
                                 (position-y (position y-name (send data :active-variables '(numeric category)) :test 'equal))
                                 
                                 (types (select (send data :active-types '(numeric category)) 
                                                (remove position-y (iseq num-vars) :test 'equal)))
                                 (x-matrix (apply 'bind-columns 
                                                  (select (column-list (send data :active-data-matrix '(numeric category)))
                                                          (remove position-y (iseq num-vars)))))
                                 (x-names (select (send data :active-variables '(numeric category)) 
                                                  (remove position-y (iseq num-vars) :test 'equal)))
                                 (first-model (iseq (length x-names)))
                                 (design-matrix-with-names (design-matrix x-matrix types first-model x-names))
                                
                                 (blocks (third design-matrix-with-names))
                                 (object (regression-model 
                                          (first design-matrix-with-names)
                                          y-vector
                                          :response-name y-name
                                          :predictor-names (second design-matrix-with-names)))
                                 ;object just to start with
                                 (labels (send data :active-labels))
                                 (vars (send current-data :active-variables '(numeric category)))
                                 (initial-model (list object)))
                                
                                (send vista-RewCat-proto
                                            :new "RewCat" data title name nil object vars labels
                                            y-name y-vector x-names x-matrix initial-model types blocks excluded-categories))
                                     
                                 (send (send ok :dialog) :close)
                               )))
           (cancel (send button-item-proto :new "Cancel" :action #'(lambda () (send (send cancel :dialog) :close))))
           (dialog (send dialog-proto :new (list (list list-variables)
                                  (list ok cancel ))))
           
           )))
     
      


   (load (strcat *RewCat-plugin-path* "Regcat2.lsp"))
   (load (strcat *RewCat-plugin-path* "Regcat3.lsp"))
   (load (strcat *RewCat-plugin-path* "Regcat4.lsp"))
   (load (strcat *RewCat-plugin-path* "Regcat6.lsp"))
   (load (strcat *RewCat-plugin-path* "Regcat7.lsp"))
  

  
  )

(provide "RewCatplg")

